/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-03-31
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef REALSTATISTICALCURVE_H
#define REALSTATISTICALCURVE_H

#include "QGpCoreMathDLLExport.h"
#include "CurveProperties.h"
#include "StatisticalPoint.h"
#include "Curve.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT RealStatisticalCurve : public Curve<RealStatisticalPoint>, public CurveProperties
  {
  public:
    RealStatisticalCurve() {}
    RealStatisticalCurve(int n)
      : Curve<RealStatisticalPoint>(n), CurveProperties() {}
    RealStatisticalCurve(const Curve<RealStatisticalPoint>& o)
      : Curve<RealStatisticalPoint>(o), CurveProperties() {}
  };

} // namespace QGpCoreMath

#endif // REALSTATISTICALCURVE_H

