/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-03-24
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "PolynomialFraction.h"

namespace QGpCoreMath {

  /*!
    \class PolynomialFraction PolynomialFraction.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void PolynomialFraction::derivate()
  {
    Polynomial numDer(_numerator);
    numDer.derivate();
    Polynomial denomDer(_denominator);
    denomDer.derivate();
    numDer*=_denominator;
    numDer-=denomDer*_numerator;
    _numerator=numDer;
    _denominator*=_denominator;
  }

  void PolynomialFraction::inverse()
  {
    Polynomial tmp(_numerator);
    _numerator=_denominator;
    _denominator=tmp;
  }

  QString PolynomialFraction::toString() const
  {
    if(_denominator.degree()>0 || _denominator.coefficient(0)!=1.0) {
      return "["+_numerator.toString()+"] / ["+_denominator.toString()+"]";
    } else {
      return "["+_numerator.toString()+"]";
    }
  }

} // namespace QGpCoreMath

