/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-03-21
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef POLYNOMIAL_H
#define POLYNOMIAL_H

#include "QGpCoreMathDLLExport.h"
#include "DoubleMatrix.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Polynomial
  {
  public:
    Polynomial(int degree);
    Polynomial(double c0, double c1);
    Polynomial(double c0, double c1, double c2);
    Polynomial(double c0, double c1, double c2, double c3);

    int degree() const {return _coefficients.count()-1;}
    int effectiveDegree() const;
    void setDegree(int newDegree);

    void setCoefficient(int exponent, double c) {_coefficients[exponent]=c;}
    double coefficient(int exponent) const {return _coefficients[exponent];}

    double value(double x) const;

    VectorList<Complex> allRoots() const;
    VectorList<double> realRoots(double precision=0.0, double minImaginaryRatio=1e-12) const;

    void derivate();
    Polynomial operator*(double f) const;
    Polynomial operator/(double f) const;
    Polynomial operator*(const Polynomial& o) const;
    Polynomial operator+(const Polynomial& o) const;
    Polynomial operator-(const Polynomial& o) const;
    void operator+=(const Polynomial& o);
    void operator-=(const Polynomial& o);
    void operator*=(const Polynomial& o) {*this=*this*o;}
    void operator*=(double f);
    void operator/=(double f);

    double multiple(const Polynomial& o, bool& ok) const;

    QString toString() const;
  private:
    VectorList<double> _coefficients;
  };

} // namespace QGpCoreMath

#endif // POLYNOMIAL_H

