/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-10-13
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef POLYGON_H
#define POLYGON_H

#include "QGpCoreMathDLLExport.h"
#include "Point2D.h"
#include "Segment2D.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Polygon
  {
  public:    
    void addPoint(const Point2D& p) {_points.append(p);}
    const Point2D& pointAt(int index) const {return _points.at(index);}
    Segment2D segmentAt(int index) const;
    void clear() {_points.clear();}
    int size() const {return _points.size();}

    bool isValid() const {return size()>2;}
    bool contains(const Point2D& p) const;
    Point2D project(const Point2D& p, double delta) const;
  private:
    double horizontalLineIntersection(const Segment2D& s, double atY, bool& ok) const;

    QList<Point2D> _points;
  };

} // namespace QGpCoreMath

#endif // POLYGON_H

