/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2002-10-11
**  Copyright: 2002-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NORMALDISTRIBUTION_H
#define NORMALDISTRIBUTION_H

#include "Curve.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class IrregularGrid2D;

  class QGPCOREMATH_EXPORT NormalDistribution
  {
    public:
      NormalDistribution(double mean, double stddev,double precision=1e-4);

      bool operator==(const NormalDistribution& o) const;

      double value(double x) const;
      double cumulativeValue(double x) const {
        return errorFunction((x-_mean)*_invStddev);
      }
      double probability(double a, double b) const {
        return (errorFunction((b-_mean)*_invStddev)
                -errorFunction((a-_mean)*_invStddev));
      }

      void setMean(double m) {_mean=m;}
      double mean() const {return _mean;}

      void setStddev(double s);
      double stddev() const {return 1.0/_invStddev;}
  protected:
    double errorFunction(double z) const;

    double _mean;
    double _invStddev;
    double _factor;
    double _precision;
  };

} // namespace QGpCoreMath

#endif // NORMALDISTRIBUTION_H
