/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-25
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "NamedPoint.h"

namespace QGpCoreMath {

/*!
  \class NamedPoint NamedPoint.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

QString NamedPoint::toString(char format, int precision) const
{
  TRACE;
  QString tmp;
  tmp+=Point::toString(format, precision);
  tmp+=" ";
  tmp+=_name;
  return tmp;
}

bool NamedPoint::fromString(StringSection str)
{
  TRACE;
  const QChar * ptr=0;
  bool ok=true;
  StringSection f;
  f=str.nextField(ptr);
  if(f.isValid()) {
    setX(f.toDouble(ok));
  } else {
    return false;
  }
  f=str.nextField(ptr);
  if(f.isValid()) {
    setY(f.toDouble(ok));
  } else {
    return false;
  }
  f=str.nextField(ptr);
  if(f.isValid()) {
    setZ(f.toDouble(ok));
  } else {
    setZ(0.0);
  }
  f=str.nextField(ptr);
  if(f.isValid()) {
    _name=f.toStringBuffer();
  } else {
    _name=QString();
  }
  return ok;
}

} // namespace QGpCoreMath
