/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-06-15
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GRIDSEARCH1D_H
#define GRIDSEARCH1D_H

#include "FunctionSearch.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT GridSearch1D : public FunctionSearch
  {
  public:
    GridSearch1D(size_t dimensionCount=1);
    ~GridSearch1D();

    void setGrid(double min, double max, double step);

    void globalMax(double absThres);
    void localMax(int nMax, double absThres, double relThres);

    static void showProcessingTime();
  private:
    double refineMax(double val);
    inline void setCurrentPosition(int i);

    int _min, _max;
    double _step;
  };

} // namespace QGpCoreMath

#endif // GRIDSEARCH1D_H

