/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-06-10
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FUNCTIONSEARCHMAXIMUM_H
#define FUNCTIONSEARCHMAXIMUM_H

#include "PrivateVector.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT FunctionSearchMaximum
  {
  public:
    inline FunctionSearchMaximum(const Vector<double>& x, double value);
    ~FunctionSearchMaximum() {}

    static bool greaterThanValue(const FunctionSearchMaximum *v1,
                                 const FunctionSearchMaximum *v2) {
      return v1->value()>v2->value();
    }

    static void setRelativePrecision(double p);
    static bool lessThanPos(const FunctionSearchMaximum *v1,
                            const FunctionSearchMaximum *v2);
    static bool equalPos(const FunctionSearchMaximum *v1,
                         const FunctionSearchMaximum *v2);

    double value() const {return _value;}
    const Vector<double>& position() const {return _position;}

  private:
    double _value;
    int _dimensionCount;
    PrivateVector<double> _position;

    static double _relativePrecision;
    static double _relativePrecision2;

    friend class FunctionSearch;
  };

  typedef VectorList<FunctionSearchMaximum *>::iterator FunctionMaximaIterator;

  inline FunctionSearchMaximum::FunctionSearchMaximum(const Vector<double>& x, double value)
    : _position(x)
  {
    _value=value;
  }

} // namespace QGpCoreMath

#endif // FUNCTIONSEARCHMAXIMUM_H

