/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-10-28
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CUBICSPLINE_H
#define CUBICSPLINE_H

#include "Point2D.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT CubicSpline
  {
  public:
    CubicSpline(int knotsCount);
    ~CubicSpline();

    void setKnot(int index, const Point2D& p) {_knots[index]=p;}
    int knotCount() const {return _knotCount;}
    const Point2D& knot(int index) const {return _knots[index];}

    void init();
    double value(double x) const;
    double value(double x, int i) const;
  private:
    int _knotCount;
    Point2D * _knots;
    double *_a, *_b, *_c, *_d;
  };

} // namespace QGpCoreMath

#endif // CUBICSPLINE_H

