/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-10-28
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CubicSpline.h"

namespace QGpCoreMath {

  /*!
    \class CubicSpline CubicSpline.h
    \brief Brief description of class still missing

    Full description of class still missing

    echo | awk '{for(i=0.1; i<6; i+=0.1) print i}' | gpcurve -spline 1 2 3 5 6 -1 | figue -c
  */

  /*!
    Description of constructor still missing
  */
  CubicSpline::CubicSpline(int knotCount)
  {
    _knotCount=knotCount;
    _knots=new Point2D[_knotCount];
    _a=new double[knotCount];
    _b=new double[knotCount-1];
    _c=new double[knotCount];
    _d=new double[knotCount-1];
  }

  /*!
    Description of destructor still missing
  */
  CubicSpline::~CubicSpline()
  {
    delete [] _knots;
    delete [] _a;
    delete [] _b;
    delete [] _c;
    delete [] _d;
  }

  /*!
    Algorithm from https://en.wikipedia.org/wiki/Spline_(mathematics)
  */
  void CubicSpline::init()
  {
    int n=knotCount()-1;
    for(int i=0; i<knotCount(); i++) {
      _a[i]=knot(i).y();
    }
    double * h=new double[n];
    for(int i=0; i<n; i++) {
      h[i]=knot(i+1).x()-knot(i).x();
    }
    double * alpha=new double[n-1]-1;
    for(int i=1; i<n; i++) {
      alpha[i]=3.0*((_a[i+1]-_a[i])/h[i]-(_a[i]-_a[i-1])/h[i-1]);
    }
    double * l=new double[knotCount()];
    double * mu=new double[knotCount()];
    double * z=new double[knotCount()];
    l[0]=1.0;
    mu[0]=0.0;
    z[0]=0.0;
    for(int i=1; i<n; i++) {
      l[i]=2.0*(knot(i+1).x()-knot(i-1).x())-h[i-1]*mu[i-1];
      mu[i]=h[i]/l[i];
      z[i]=(alpha[i]-h[i-1]*z[i])/l[i];
    }
    l[n]=1.0;
    z[n]=0.0;
    _c[n]=0.0;
    for(int i=n-1; i>=0; i--) {
      _c[i]=z[i]-mu[i]*_c[i+1];
      _b[i]=(_a[i+1]-_a[i])/h[i]-h[i]*(_c[i+1]+2.0*_c[i])/3.0;
      _d[i]=(_c[i+1]-_c[i])/(3.0*h[i]);
    }
  }

  double CubicSpline::value(double x) const
  {
    int n=knotCount()-1;
    for(int i=1; i<n; i++) {
      if(x<knot(i).x()) {
        return value(x, i-1);
      }
    }
    return value(x, n-1);
  }

  double CubicSpline::value(double x, int i) const
  {
    double dx=x-knot(i).x();
    double dx2=dx*dx;
    return _a[i]+_b[i]*dx+_c[i]*dx2+_d[i]*dx*dx2;
  }

} // namespace QGpCoreMath

