/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-03-20
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CUBICEQUATION_H
#define CUBICEQUATION_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT CubicEquation
  {
  public:
    CubicEquation();

    void setEquation(double a, double b, double c, double d);
    double discriminant() const {return _delta;}
    double root(int index) const {return _roots[index].re();}

    double value(double x) const;
    Complex value(const Complex& x) const;
    double firstDerivative(double x) const;
    void checkRoots() const;
  private:
    double _third;
    Complex _unityRoot, _unityRoot2;

    double _a, _b, _c, _d;
    double _delta;
    Complex _roots[3];
  };

} // namespace QGpCoreMath

#endif // CUBICEQUATION_H

