/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-01-09
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CONCENTRICSEARCH_H
#define CONCENTRICSEARCH_H

#include "FunctionSearch.h"
#include "Angle.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

class AbstractFunction;

class QGPCOREMATH_EXPORT ConcentricSearch : public FunctionSearch
{
public:
  ConcentricSearch();
  ~ConcentricSearch();

  void setGrid(double minR, double maxR, double dR);
  void setMaximumRadius(double maxR) {_rMax=maxR;}
  void setCenter(double x, double y) {_x=x; _y=y;}
  void setNoiseLevel(double nl) {_noiseLevel=nl;}

  double maximum(QAtomicInt * terminate=nullptr);
  double maxX() const {return _maxX;}
  double maxY() const {return _maxY;}
  double maxRadius() const;
  Angle maxAngle() const {return Angle(_maxX-_x, _maxY-_y);}
  Angle maxAngle(double radius) const {return Angle(_maxX-_x, _maxY-_y, radius);}
  double r0() const;
  double dr() const {return _dr;}
private:
  enum Segment {Top, Bottom, Left, Right};
  bool scanX(double min, double max, double y);
  bool scanY(double min, double max, double x);
  void crossRefineX(double x, double y, double dr);
  void crossRefineY(double x, double y, double dr);

  mutable Mutex _r0Mutex;
  double _r0, _dr, _rMax, _noiseLevel;
  Segment _segment;
  double _x, _y, _pos;
  double _precision;
  double _v1, _v2, _v3;
  double _maxValue, _maxX, _maxY;
};

} // namespace QGpCoreMath

#endif // CONCENTRICSEARCH_H
