/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-11
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COLORPALETTEMODELS_H
#define COLORPALETTEMODELS_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class ColorPalette;

  class QGPCOREMATH_EXPORT ColorPaletteModels : public GlobalObject
  {
  public:
    ColorPaletteModels();
    virtual ~ColorPaletteModels();

    static ColorPaletteModels * instance();

    const ColorPalette * palette(const QString& model);
    QString credits(const QString& model);
    QStringList list() const;

    static QString path();
    static QList<QDir> sources();
    static ColorPalette * loadPalette(const QString& fileName);
  private:
    class Palette {
    public:
      Palette(ColorPalette * pal, int creditIndex) {
        _pal=pal;
        _creditIndex=creditIndex;
      }

      ColorPalette * _pal;
      int _creditIndex;
    };
    QMap<QString, Palette> _palettes;
    QStringList _credits;
    static ColorPaletteModels * _self;
  };

} // namespace QGpCoreMath

#endif // COLORPALETTEMODELS_H

