/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-11-07
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef BSPLINE_H
#define BSPLINE_H

#include "Point2D.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT BSpline
  {
  public:
    BSpline(int controlPointCount, int order, double mint=0.0, double maxt=1.0);
    ~BSpline();

    void setControlPoint(int index, const Point2D& p) {_controlPoints[index]=p;}
    int controlPointCount() const {return _controlPointCount;}
    const Point2D& controlPoint(int index) const {return _controlPoints[index];}

    int order() const {return _n;}

    double minimumT() const;
    double maximumT() const;
    Point2D value(double t) const;
  private:
    inline double weight(int j, int n, double t) const;
    double base(int j, int n, double t) const;

    int _controlPointCount;
    Point2D * _controlPoints;
    double * _knots;
    int _n;
  };

} // namespace QGpCoreMath

#endif // BSPLINE_H

