/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-04-11
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTNUMERICALCACHE_H
#define ABSTRACTNUMERICALCACHE_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"
#include "AbstractNumericalKey.h"

namespace QGpCoreMath {

  class HashNumericalKey;

  class QGPCOREMATH_EXPORT AbstractNumericalCache: public GlobalObject
  {
  public:
    inline AbstractNumericalCache(AbstractNumericalKey * key);
    ~AbstractNumericalCache() {delete _key;}

    virtual void init()=0;
    const AbstractNumericalKey& key() const {return *_key;}

    static const AbstractNumericalCache * begin(AbstractNumericalKey * key);
    static void end(const AbstractNumericalCache * cache);
  private:
    static AbstractNumericalCache * add(AbstractNumericalKey * key);

    clock_t lastUse() const {return _lastUse;}
    void use() const {_lastUse=clock();}

    AbstractNumericalKey * _key;
    mutable clock_t _lastUse;
    mutable ReadWriteLock _locked;

    static Mutex _mutex;
    static QHash<HashNumericalKey, AbstractNumericalCache *> _caches;
  };

  inline AbstractNumericalCache::AbstractNumericalCache(AbstractNumericalKey * key)
  {
    _key=key;
    _lastUse=clock();
  }

} // namespace QGpCoreMath

#endif // ABSTRACTNUMERICALCACHE_H
