/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-11-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "CompatSrcHodochrone.h"

namespace QGpCompatibility {

#if 0
const QString CompatSrcHodochrone::xmlSrcHodochroneTag="SrcHodochrone";

void CompatSrcHodochrone::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  writeProperty(s, "src", QString( "%1 %2 %3" ).arg(_src.x()).arg(_src.y()).arg(_src.z()) );
}

void CompatSrcHodochrone::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  char buf[ 16 ];
  for(int i=0;i < nRec();i++ ) {
    sprintf(buf, "rec=\"%i\"", i);
    ( *this) [ i ].xml_save(s, buf);
  }
}

XMLMember CompatSrcHodochrone::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  if(tag=="src" ) return XMLMember(0);
  if(tag=="ArrivalTime" ) {
    static const QString tmp( "rec" );
    XMLRestoreAttributeIterator it=map.find(tmp);
    if(it!=map.end()) {
      int i=it.value().toInt();
      if(i < nRec()) return XMLMember(&receiver( i) );
      else {
        App::log(tr( "Rec index %1 out of range, max=%2\n" ).arg(i).arg(nRec()) << Qt::endl;
        return XMLMember(XMLMember::Unknown);
      }
    } else {
      App::log(tr( "Attribute rec not d"));
      return XMLMember(XMLMember::Unknown);
    }
  } else return XMLMember(XMLMember::Unknown);
}

bool CompatSrcHodochrone::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  if(memberID==0) {
    _src.fromString(content);
    return true;
  } else return false;
}
#endif

} // namespace QGpCompatibility
