/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-17
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATHODOCHRONEDATA_H
#define COMPATHODOCHRONEDATA_H

#include <QGpCoreWave.h>
#include "CompatHodoChrone.h"
#include "CompatMultiModalData.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

class QGPCOMPATIBILITY_EXPORT CompatHodoChroneData : public CompatHodoChrone, public CompatMultiModalData
{
public:
  /// default constructor
  CompatHodoChroneData(): 
      CompatHodoChrone(), CompatMultiModalData() {}
  /// Allocates an empty structure
  CompatHodoChroneData(int modesCount,int omegasCount):
      CompatHodoChrone(modesCount, omegasCount),
      CompatMultiModalData(modesCount, omegasCount) {}
  /// Allocates an empty structure based on an existing one with another number of modes
  CompatHodoChroneData(const CompatHodoChroneData * o,int modesCount):
      CompatHodoChrone(o, modesCount),
      CompatMultiModalData(o, modesCount, CompatHODOCHRONE_INVALID_VALUE) {}
  /// Set the values o as the measurements
  CompatHodoChroneData(const CompatMultiModalCurves * o):
      CompatHodoChrone(o),
      CompatMultiModalData(o) {}
  void setSource(QString srcFile);
  void calculate(RefractionDippingModel& model);
  int srcIndex(int iSrc);
  //void rays(RefractionDippingModel& model, CompatDynXYColorLines * raysLayer);
  void valuesToData() {CompatMultiModalData::valuesToData(this);}
  void valuesToData(CompatMultiModalCurves * o) {CompatMultiModalData::valuesToData(o);}
};

} // namespace QGpCompatibility

#endif // COMPATHODOCHRONEDATA_H
