/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "CompatDataPoint.h"

namespace QGpCompatibility {

const QString CompatDataPoint::xmlDataPointTag="DataPoint";
const QString CompatDataPointVector::xmlDataPointVectorTag="DataPointVector";
const QString CompatVDataPointVector::xmlVDataPointVectorTag="DataPointVector";

QDataStream& operator>> (QDataStream& s, CompatDataPoint& p)
{
  TRACE;
  s >> p.mean() >> p.stddev() >> p.weight();
  return s;
}

QDataStream& operator<< (QDataStream& s, const CompatDataPoint& p)
{
  TRACE;
  s << p.mean() << p.stddev() << p.weight();
  return s;
}

void CompatDataPoint::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  writeProperty(s, "mean",_mean);
  writeProperty(s, "stddev",_stddev);
  writeProperty(s, "weight",_weight);
}

XMLMember CompatDataPoint::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag=="mean") return XMLMember(0);
  else if(tag=="stddev") return XMLMember(1);
  else if(tag=="weight") return XMLMember(2);
  else return false;
  return true;  
}

bool CompatDataPoint::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  bool ok=true;
  switch(memberID) {
  case 0: _mean=content.toDouble(ok); return ok;
  case 1: _stddev=content.toDouble(ok); return ok;
  case 2: _weight=content.toDouble(ok); return ok;
  default: return false;
  }
}

VectorList<double> * CompatDataPointVector::meanVector() const
{
  VectorList<double> * list=new VectorList<double>;
  for(int i=0;i<size();i++) list->append(at(i).mean());
  return list;
}

VectorList<double> * CompatDataPointVector::stddevVector() const
{
  VectorList<double> * list=new VectorList<double>;
  for(int i=0;i<size();i++) list->append(at(i).stddev());
  return list;
}

VectorList<double> * CompatDataPointVector::weightVector() const
{
  VectorList<double> * list=new VectorList<double>;
  for(int i=0;i<size();i++) list->push_back(at(i).weight());
  return list;
}

XMLMember CompatDataPointVector::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag=="DataPoint") {
    append(CompatDataPoint());
    return XMLMember(&last());
  } else return XMLMember(XMLMember::Unknown);
}

void CompatDataPointVector::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  static const QString key("index");
  XMLSaveAttributes att;
  QString& value=att.add(key);
  for(int i=0;i<size();i++) {
    value=QString::number(i);
    at(i).xml_save(s, context, att);
  }
}

VectorList<double> * CompatVDataPointVector::valueVector() const
{
  VectorList<double> * list=new VectorList<double>;
  for(int i=0;i<size();i++) list->append(at(i).value());
  return list;
}

VectorList<double> * CompatVDataPointVector::meanVector() const
{
  VectorList<double> * list=new VectorList<double>;
  for(int i=0;i<size();i++) list->append(at(i).mean());
  return list;
}

VectorList<double> * CompatVDataPointVector::stddevVector() const
{
  VectorList<double> * list=new VectorList<double>;
  for(int i=0;i<size();i++) list->append(at(i).stddev());
  return list;
}

VectorList<double> * CompatVDataPointVector::weightVector() const
{
  VectorList<double> * list=new VectorList<double>;
  for(int i=0;i<size();i++) list->push_back(at(i).weight());
  return list;
}

XMLMember CompatVDataPointVector::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag=="DataPoint") {
    append(CompatVDataPoint());
    return XMLMember(&last());
  } else return XMLMember(XMLMember::Unknown);
}

void CompatVDataPointVector::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  static const QString key("index");
  XMLSaveAttributes att;
  QString& value=att.add(key);
  for(int i=0;i<size();i++) {
    value=QString::number(i);
    at(i).xml_save(s, context, att);
  }
}

} // namespace QGpCompatibility
