/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-12-12
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATISTICRESULTS_H
#define STATISTICRESULTS_H

#include <SciFigs.h>
#include <HVCore.h>

namespace HVGui {

  class StatisticResults : public GraphicSheetMenu
  {
  public:
    StatisticResults(QWidget* parent=nullptr);
    ~StatisticResults();

    void createObjects(QStringList& graphTitles);
    void setStatPlot(int graphIndex);
    void setStatPlot(int graphIndex,
                     const Curve<Point2D>& curve0,
                     const Curve<Point2D>& curve1,
                     const Curve<Point2D>& curve2);
    inline ParallelBands * frequencyLayer(int graphIndex) const;
    inline LineLayer * averageLayer(int graphIndex) const;

    void setBandsPlot(int graphIndex, const CurveResults * res);

    static void studentTest(QWidget * parent, const CurveResults * ref, const CurveResults * other,
                            double significance, const QString& makeUp=QString());
  private:
    VectorList<ParallelBands *> _frequencyLayers;
    VectorList<LineLayer *> _averageLayers;
  };

  inline ParallelBands * StatisticResults::frequencyLayer(int graphIndex) const
  {
    TRACE;
    return _frequencyLayers.at(graphIndex);
  }

  inline LineLayer * StatisticResults::averageLayer(int graphIndex) const
  {
    TRACE;
    return _averageLayers.at(graphIndex);
  }

} // namespace HVGui

#endif
