/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-02-14
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTHVTOOL_H
#define ABSTRACTHVTOOL_H

#include <GeopsyCore.h>

#include "HVCoreDLLExport.h"
#include "HVParameters.h"
#include "HVTaskManager.h"

namespace HVCore {

  class CurveResults;

  class HVCORE_EXPORT AbstractHVTool : public AbstractTool
  {
  public:
    AbstractHVTool(QObject * parent);
    ~AbstractHVTool();

    bool setSubPool(SubSignalPool * subPool);

    inline const HVParameters * parameters() const;
    inline HVParameters * parameters();

    const QList<AbstractStation *>& stations() const {return _stations;}

    void autoWindows(QList<AbstractStation *> * stations=nullptr);
    void inverseWindows(QList<AbstractStation *> * stations=nullptr);
    void addWindows(AbstractStation * stat, const TimeRange * r=nullptr, QString log=QString());
    void removeWindows(AbstractStation * stat, const TimeRange& r);
    bool addWindows(Signal * sig);
    bool loadWindows(const QStringList& fileNames);

    void setWindowColors();
    void setStatistics();
    void setPeaks();
    bool saveResults(const QString& outputDir);
  protected:
    void setStations();
    virtual AbstractStation * createStation(StationSignals * sigs)=0;
    ParallelTaskManager * createLoop();

    StationList _stationSignals;
    QList<AbstractStation *> _stations;
  private:
    SparseKeepSignal * globalKeep(const TimeRange& r);
  };

  inline const HVParameters * AbstractHVTool::parameters() const
  {
    return static_cast<const HVParameters *>(AbstractTool::parameters());
  }

  inline HVParameters * AbstractHVTool::parameters()
  {
    return static_cast<HVParameters *>(AbstractTool::parameters());
  }

} // namespace HVCore

#endif // ABSTRACTHVTOOL_H

