/***************************************************************************
**
**  This file is part of GeopsyPySciFigs.
**
**  GeopsyPySciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPySciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-24
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PYTHONCLASSFACTORY_H
#define PYTHONCLASSFACTORY_H

#ifdef HAS_PYTHON
#include "PythonNumPy.h"
#include <QGpCoreTools.h>

struct QtObjectData;

#define DECL_VALUE_FUNCTION(h, t, u) \
  static PyObject * value_##h##t##u(QtObjectData * self, PyObject *); \
  static PyObject * setValue_##h##t##u(QtObjectData * self, PyObject * args);

#define IMPL_VALUE_FUNCTION(h, t, u) \
  PyObject * PythonClassFactory::value_##h##t##u(QtObjectData * self, PyObject *) \
  { \
    return value(self->objectId, h*100+t*10+u); \
  } \
  PyObject * PythonClassFactory::setValue_##h##t##u(QtObjectData * self, PyObject * args) \
  { \
    return setValue(self->objectId, h*100+t*10+u, args); \
  }


#define DECL_METHOD_FUNCTION(h, t, u) \
  static PyObject * method_##h##t##u(QtObjectData * self, PyObject *);

#define IMPL_METHOD_FUNCTION(h, t, u) \
PyObject * PythonClassFactory::method_##h##t##u(QtObjectData * self, PyObject * args) \
{ \
  return method(self->objectId, h*100+t*10+u, args); \
}

#define MULTIPLE_FUNCTION_10(FUNCTION, h, t) \
    FUNCTION(h, t, 0) \
    FUNCTION(h, t, 1) \
    FUNCTION(h, t, 2) \
    FUNCTION(h, t, 3) \
    FUNCTION(h, t, 4) \
    FUNCTION(h, t, 5) \
    FUNCTION(h, t, 6) \
    FUNCTION(h, t, 7) \
    FUNCTION(h, t, 8) \
    FUNCTION(h, t, 9)

#define MULTIPLE_FUNCTION_100(FUNCTION, h) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 0) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 1) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 2) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 3) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 4) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 5) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 6) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 7) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 8) \
  MULTIPLE_FUNCTION_10(FUNCTION, h, 9)

#define MULITPLE_FUNCTION_COUNT 100
#define MULTIPLE_FUNCTION(FUNCTION) \
  MULTIPLE_FUNCTION_100(FUNCTION, 0)


class PythonClassFactory
{
public:
  PythonClassFactory();
  ~PythonClassFactory();

  static PythonClassFactory * instance() {return _self;}

  bool add(XMLClassFactory * factory);
  bool add(const QMetaObject * object);
  void cleanFunctionMaps();

  int propertyOffset(const QString& className) const;
  int methodOffset(const QString& className) const;
  const QMetaObject * metaObject(const QString& className) const;
  PyObject * create(const QString& className, int objectId) const;

  static int objectId(PyObject * obj);
private:
  struct TypeInfo {
    PyTypeObject * pyObject;
    const QMetaObject * qtObject;
    int propertyOffset, methodOffset;
  };
  QMap<QString, TypeInfo> _types;
  QList<QByteArray> _methodNames;
  PyCFunction * _mapValues, * _mapSetValues, * _mapMethods;

  bool addMethods(TypeInfo& type);
  bool isAcceptableMethod(const QMetaMethod& m);
  static PyObject * value(int objectId, int propertyId);
  static PyObject * setValue(int objectId, int propertyId, PyObject * args);
  static PyObject * method(int objectId, int methodId, PyObject * args);

  MULTIPLE_FUNCTION(DECL_VALUE_FUNCTION)
  MULTIPLE_FUNCTION(DECL_METHOD_FUNCTION)

  static PythonClassFactory * _self;
};

#endif // HAS_PYTHON
#endif // PYTHONCLASSFACTORY_H

