/***************************************************************************
**
**  This file is part of GeopsyPySciFigs.
**
**  GeopsyPySciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPySciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-17
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHICALUSERINTERFACE_H
#define GRAPHICALUSERINTERFACE_H

#include <pthread.h>
#include <SciFigs.h>

class ActionExecute;
class ActionRequest;
class CurveData;
class MethodArgument;

class GraphicalUserInterface
{
public:
  GraphicalUserInterface();
  ~GraphicalUserInterface();

  static bool isFreshQtEnvironment();
  static GraphicalUserInterface * instance() {return _self;}

  static bool initPythonError(PyObject * module);
  static void setErrorMessage(const QString& msg);

  ActionExecute * execute();
  void engineStarted();
  void engineStopped();

  bool startEngine();
  void stopEngine();

  int createGraphicSheet();
  int createAxisWindow(int parentId=-1);

  QVariant propertyValue(int objectId, int propertyId) const;
  bool setPropertyValue(int objectId, int propertyId, PyObject * args) const;
  MethodArgument * method(int objectId, int methodId, PyObject * args) const;

  void addCurves(int parentId, CurveData * d);
  void setVerbosity(int level);

  int objectId(QObject * obj) const;
  QObject * object(int objectId) const;
  int addObject(QObject * obj);
private:
  void waitForStarted();
  void waitForStopped();
  static bool isQtApplicationAvailable();
  static void * run(void * arg);

  static GraphicalUserInterface * _self;
  pthread_t _threadId;
  ActionExecute * _execute;
  ActionRequest * _request;
  static PyObject * _error;
  QAtomicInt _engineRunning;
};

#endif // GRAPHICALUSERINTERFACE_H

