/*****
**  Created : 2023-11-14
*****/

#ifdef HAS_PYTHON
#include "PythonNumPy.h"
#include "PythonClassFactory.h"
#include "GraphicalUserInterface.h"
#include "GeopsyPySciFigsVersion.h"
#include "GeopsyPySciFigsInstallPath.h"
#include "MethodArgument.h"
#include "CurveData.h"

PACKAGE_INFO("GeopsyPySciFigs", GEOPSYPYSCIFIGS)

typedef struct {
  PyObject_HEAD
  int objectId;
} GraphicObjectData;

/*static PyObject * GraphicObject_name(GraphicObjectData * self, PyObject *)
{
  QString name("Dispersion");
  return PyUnicode_FromKindAndData(PyUnicode_2BYTE_KIND, name.data(), name.size());
}

static PyObject * GraphicObject_setName(GraphicObjectData * self, PyObject * args)
{
  PyObject * argName=NULL;
  if (!PyArg_ParseTuple(args, "O", &argName)) {
    return NULL;
  }
  Py_RETURN_NONE;
}

static PyMethodDef GraphicObjectMethods[] = {
    {"name", (PyCFunction) GraphicObject_name, METH_NOARGS,
     "Returns the name of the graphic object."},
    {"setName", (PyCFunction) GraphicObject_setName, METH_NOARGS,
     "Sets the name of the graphic object."},
    {NULL}
};

static PyTypeObject GraphicObjectType={
    .ob_base=PyVarObject_HEAD_INIT(NULL, 0)
                   .tp_name="GeopsyPySciFigs.GraphicObject",
    .tp_basicsize=sizeof(GraphicObjectData),
    .tp_itemsize=0,
    .tp_flags=Py_TPFLAGS_DEFAULT,
    .tp_doc=PyDoc_STR("Graphic object base class"),
    .tp_methods=GraphicObjectMethods,
    .tp_new=PyType_GenericNew,
};*/

static PyObject * GeopsyPySciFigs_setVerbosity(PyObject *, PyObject * args)
{
  int level;
  if (!PyArg_ParseTuple(args, "i", &level)) {
    return NULL;
  }
  GraphicalUserInterface::instance()->setVerbosity(level);
  Py_RETURN_NONE;
}

static PyObject * GeopsyPySciFigs_newSheet(PyObject *, PyObject *)
{
  int wId=GraphicalUserInterface::instance()->createGraphicSheet();
  if(wId>0) {
    return PythonClassFactory::instance()->create("SciFigs::GraphicSheet", wId);
  } else {
    Py_RETURN_NONE;
  }
}

static PyObject * GeopsyPySciFigs_newPlot(PyObject *, PyObject * args)
{
  PyObject * argParent=NULL;
  if (!PyArg_ParseTuple(args, "|O", &argParent)) {
    return NULL;
  }
  int wId;
  if(argParent==NULL) {
    wId=GraphicalUserInterface::instance()->createAxisWindow();
  } else {
    wId=GraphicalUserInterface::instance()->createAxisWindow(PythonClassFactory::objectId(argParent));
  }
  if(wId>0) {
    return PythonClassFactory::instance()->create("SciFigs::AxisWindow", wId);
  } else {
    Py_RETURN_NONE;
  }
}

static PyObject * GeopsyPySciFigs_addCurves(PyObject *, PyObject * args)
{
  PyObject * argParent=NULL, * argX=NULL, * argY=NULL;
  if (!PyArg_ParseTuple(args, "OOO", &argParent, &argX, &argY)) {
    return NULL;
  }

  CurveData cd;
  if(!cd.setArguments(argX, argY)) {
    return NULL;
  }
  GraphicalUserInterface::instance()->addCurves(PythonClassFactory::objectId(argParent), &cd);
  Py_RETURN_NONE;
}

static void GeopsyPySciFigs_pythonEnds()
{
  GraphicalUserInterface::instance()->stopEngine();
}

static PyMethodDef GeopsyPySciFigsMethods[]={
    {"setVerbosity", GeopsyPySciFigs_setVerbosity, METH_VARARGS,
     "Set verbosity level (-1=no ouput, 0=normal, 1=more verbose, 2=even more,...)."},
    {"newSheet", GeopsyPySciFigs_newSheet, METH_NOARGS,
     "GraphicSheet * newSheet(): creates a new graphical sheet."},
    {"newPlot", GeopsyPySciFigs_newPlot, METH_VARARGS,
     "AxisWindow * newPlot([arrayX, arrayY]): Creates a new 2D plot outside a graphical sheet."},
    {"addCurves", GeopsyPySciFigs_addCurves, METH_VARARGS,
     "addCurves(arrayX, arrayY, AxisWindow * plot): adds curves to an existing plot."},
    {NULL, NULL, 0, NULL}
};

static struct PyModuleDef GeopsyPySciFigsModule={
    PyModuleDef_HEAD_INIT,
    "GeopsyPySciFigs",                       // m_name
    "Python interfacto to SciFigs library",  // m_doc
    -1,                                      // m_size
    GeopsyPySciFigsMethods,                  // m_methods
    NULL,                                    // m_slots
    NULL,                                    // m_traverse
    NULL,                                    // m_clear
    NULL                                     // m_free
};

PyMODINIT_FUNC PyInit_GeopsyPySciFigs(void)
{
  printf("Init GeopsyPySciFigs module\n");
  PyObject * mod=PyModule_Create(&GeopsyPySciFigsModule);
  if(mod==NULL) {
    return NULL;
  }
  import_array();   // numpy arrays

  if(!GraphicalUserInterface::initPythonError(mod)) {
    Py_DECREF(mod);
    return NULL;
  }

  if(GraphicalUserInterface::instance()) {
    //TODO("Connect to existing interface.");
  } else {
    GraphicalUserInterface * g=new GraphicalUserInterface;
    if(!g->startEngine()) {
      Py_DECREF(mod);
      return NULL;
    }
  }

  MethodArgument::initTypes();
  PythonClassFactory * classFactory=new PythonClassFactory;
  if(!classFactory->add(GraphicObjectFactory::instance()) ||
     !classFactory->add(&Axis::staticMetaObject) ||
     !classFactory->add(&GraphContents::staticMetaObject) ||
     !classFactory->add(GraphContentsLayerFactory::instance()) ||
     !classFactory->add(&GraphicSheet::staticMetaObject)) {
    GraphicalUserInterface::instance()->stopEngine();
    Py_DECREF(mod);
    return NULL;
  }
  classFactory->cleanFunctionMaps();

  /*Py_INCREF(&GraphicObjectType);
  if (PyModule_AddObject(mod, "GraphicObject", (PyObject *) &GraphicObjectType)<0) {
    Py_DECREF(&GraphicObjectType);
    Py_DECREF(mod);
    return NULL;
  }*/

  Py_AtExit(GeopsyPySciFigs_pythonEnds);

  return mod;
}

#endif // HAS_PYTHON
