/***************************************************************************
**
**  This file is part of GeopsyPySciFigs.
**
**  GeopsyPySciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPySciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-21
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIONEXECUTE_H
#define ACTIONEXECUTE_H

#ifdef HAS_PYTHON
#include "PythonNumPy.h"

#include <SciFigs.h>

class CurveData;
class MethodArgument;

class ActionExecute : public QObject
{
  Q_OBJECT
public:
  ActionExecute();
  ~ActionExecute();

  void initAcknowledge(QWaitCondition * m);

  int find(QObject * obj) const;
  template <class T> T * find(int objectId) const;
  int addObject(QObject * obj);
public slots:
  void createGraphicSheet(int * objectId);
  void createAxisWindow(int parentId, int * objectId);
  void addCurves(int parentId, const CurveData * d);
  void propertyValue(int objectId, int propertyId, QVariant * val);
  void setPropertyValue(int objectId, int propertyId, PyObject * args, bool * ok);
  void method(int objectId, int methodId, PyObject * args, MethodArgument ** returnValue);
  void setVerbosity(int level);
  void quit();
private slots:
  void objectDestroyed(QObject * obj);
private:
  void dumpIds() const;
  void acknowledge();
  void addCurves(AxisWindow * w, const CurveData * d);
  static void setLimits(AxisWindow * w);

  QWaitCondition * _acknowledge;
  int _nextWidgetId;
  mutable QMutex _objectLists;
  QMap<int, QObject *> _idsToObjects;
  QMap<QObject *, int> _objectsToIds;
  Legend _legend;
};

template <class T>
T * ActionExecute::find(int objectId) const
{
  _objectLists.lock();
  QMap<int, QObject *>::const_iterator it=_idsToObjects.find(objectId);
  if(it!=_idsToObjects.end()) {
    QObject * obj=it.value();
    _objectLists.unlock();
    return qobject_cast<T *>(obj);
  } else {
    _objectLists.unlock();
    return nullptr;
  }
}

#endif // HAS_PYTHON
#endif // ACTIONEXECUTE_H

