/***************************************************************************
**
**  This file is part of GeopsyPyCoreWave.
**
**  GeopsyPyCoreWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPyCoreWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-16
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifdef HAS_PYTHON
#define PY_SSIZE_T_CLEAN
#include <Python.h>

#include "PythonError.h"

/*!
  \class PythonError PythonError.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

PythonError PythonError::_self;

/*!
  Description of constructor still missing
*/
PythonError::PythonError()
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
PythonError::~PythonError()
{
  TRACE;
}

bool PythonError::init(PyObject * module)
{
  _error=PyErr_NewException("GeopsyPyCoreWave.error", NULL, NULL);
  Py_XINCREF(_error);
  if (PyModule_AddObject(module, "error", _error)<0) {
    Py_XDECREF(_error);
    Py_CLEAR(_error);
    Py_DECREF(module);
    return false;
  } else {
    return true;
  }
}

void PythonError::setString(const QString& msg)
{
  PyErr_SetString(_self._error, msg.toLocal8Bit().data());
}

#endif // HAS_PYTHON
