#!/usr/bin/python3.7

import numpy as np
import GeopsyPyCoreWave as gp
import matplotlib.pyplot as plt

nmodes=7
group=0

#gp.setVerbosity(2)
freq=np.logspace(np.log10(1), np.log10(50), 100)
omega=freq.copy()
omega*=2*np.pi

h=np.array([10,20])
vp=np.array([500,1000,3000])
vs=np.array([200,600,1500])
rho=np.array([2000,2000,2500])

slow=gp.LoveDispersionCurve(nmodes, group, h, vs, rho, omega)
vel=1./slow

fig, ax=plt.subplots()
for i in range(0, nmodes-1):
  ax.loglog(freq, vel[i])

ax.set(xlim=(1, 50), ylim=(100, 2000), xlabel="Frequency [Hz]", ylabel="Velocity [m/s]")
plt.show()
