/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RELATIVEPOSITIONS_H
#define RELATIVEPOSITIONS_H

#include <QGpCoreMath.h>
#include <QGpGuiTools.h>

#include "ui_RelativePositions.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT RelativePositionsDelegate : public ItemDelegate
{
  Q_OBJECT
public:
  RelativePositionsDelegate(QObject *parent=nullptr);

  QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                         const QModelIndex &index) const;
  void clearStations() {_stationList.clear();}
  void addStation(QString stationName) {_stationList << ("%1. "+ stationName).arg(_stationList.count()+1);}
  int indexOf(QString stationName) {return _stationList.indexOf(stationName);}
  QString stationAt(int i) {return _stationList.at(i);}
private:
  QStringList _stationList;
};

class GEOPSYGUI_EXPORT RelativePositions : public QWidget, public Ui::RelativePositions
{
  Q_OBJECT

public:
  RelativePositions(QWidget * parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  ~RelativePositions();

  void updateAll();
public slots:
  virtual void setStationList(const QList<NamedPoint> * stations);
  virtual void addBut_clicked();
  virtual void removeBut_clicked();
  virtual void updateCurrentDistAz(QTableWidgetItem * item);
  virtual void calculateAverage();
protected:
  const QList<NamedPoint> * _stations;

};

} // namespace GeopsyGui

#endif // RELATIVEPOSITIONS_H
