/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-06-10
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PICKFORMAT_H
#define PICKFORMAT_H

#include <QGpGuiTools.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT PickFormat : public XMLClass
{
public:
  PickFormat() {}

  const QString& xml_tagName() const {return xmlPickFormatTag;}
  static const QString xmlPickFormatTag;

  //QList<int> indexList() const {return _formats.keys();}

  bool isVisible(const QString& pickName) const;
  QColor color(const QString& pickName) const;

  void setVisible(const QString& pickName, bool v);
  void setColor(const QString& pickName, const QColor& c);
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  class Format {
  public:
    Format(bool v=false, QColor c=Qt::blue) {visible=v;color=c;}

    bool visible;
    QColor color;
  };

  QMap<QString, Format> _formats;
};

} // namespace GeopsyGui

#endif // PICKFORMAT_H
