/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include <QGpCoreTools.h>
#include <QGpGuiTools.h>

#include "HeaderWidget.h"
#include "GeopsyGuiEngine.h"

namespace GeopsyGui {

  /*!
    Constructs a HeaderWidget as a child of 'parent', with the
    name 'name' and widget flags set to 'f'.

   The dialog will by default be modeless, unless you set 'modal' to
   true to construct a modal dialog.
  */
  HeaderWidget::HeaderWidget(SubSignalPool * subPool, QWidget* parent, Qt::WindowFlags f)
      : Dialog(parent, f)
  {
    TRACE;
    _subPool=subPool;

    setupUi(this);
    Settings::getWidget(this);
  }

  /*!
    Destroys the object and frees any allocated resources
  */
  HeaderWidget::~HeaderWidget()
  {
    TRACE;
  }

  void HeaderWidget::on_applyBut_clicked()
  {
    TRACE;
    SignalHeaderScript script(_subPool);
    connect(&script, SIGNAL(beginSignalChange(SignalDatabase *)), this, SLOT(beginSignalChange(SignalDatabase *)));
    connect(&script, SIGNAL(endSignalChange(SignalDatabase *)), this, SLOT(endSignalChange(SignalDatabase *)));
    connect(&script, SIGNAL(beginSignalChange(Signal *)), this, SLOT(beginSignalChange(Signal *)));
    connect(&script, SIGNAL(endSignalChange(Signal *)), this, SLOT(endSignalChange(Signal *)));
    App::setPrefix(tr("[Header] "));
    script.run(codeEditor->toPlainText());
    App::setPrefix(QString());
    Settings::setWidget(this);
  }

  void HeaderWidget::on_debugBut_clicked()
  {
    TRACE;
    SignalHeaderScript script(_subPool);
  }

  void HeaderWidget::beginSignalChange(Signal * sig)
  {
    TRACE;
    GeopsyGuiEngine::instance()->beginSignalChange(sig);
  }

  void HeaderWidget::endSignalChange(Signal * sig)
  {
    TRACE;
    GeopsyGuiEngine::instance()->endSignalChange(sig);
  }

  void HeaderWidget::beginSignalChange(SignalDatabase * db)
  {
    TRACE;
    GeopsyGuiEngine::instance()->beginSignalChange(db);
  }

  void HeaderWidget::endSignalChange(SignalDatabase * db)
  {
    TRACE;
    GeopsyGuiEngine::instance()->endSignalChange(db);
  }

  void HeaderWidget::on_loadBut_clicked()
  {
    TRACE;
    QString str=Message::getOpenFileName(tr("Open header equation file"),
                                         tr("Header equation file (*.headequ)"));
    if(str.length() > 0) {
      QFile f(str);
      f.open(QIODevice::ReadOnly);
      QTextStream s(&f);
      codeEditor->setPlainText(s.readAll());
    }
  }

  void HeaderWidget::on_saveBut_clicked()
  {
    TRACE;
    QString str=Message::getSaveFileName(tr("Save header equation file"),
                                         tr("Header equation file (*.headequ)"));
    if(str.length() > 0) {
      QFile f(str);
      f.open(QIODevice::WriteOnly);
      QTextStream s(&f);
      s << codeEditor->toPlainText();
    }
  }

} // namespace GeopsyGui
