/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-05
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GeopsyGuiInterface.h"
#include "GeopsyGuiVersion.h"
#include "GeopsyGuiInstallPath.h"

namespace GeopsyGui {

  /*!
    \class GeopsyGuiInterface GeopsyGuiInterface.h
    \brief Abstract interface for GUI Geopsy plugins
  */

  /*!
    Add the actions stored for this plugin to widget \a w. Original pointers are added
  */
  void GeopsyGuiInterface::addActions(QWidget * w) const
  {
    TRACE;
    int n=_actions.count();
    for(int i=0;i<n;i++) {
      w->addAction(_actions[i]);
    }
  }

  void GeopsyGuiInterface::addPreferenceTab(QTabWidget *)
  {
    TRACE;

  }

  void GeopsyGuiInterface::setPreferences()
  {
    TRACE;

  }

  void GeopsyGuiInterface::setHelp(ApplicationHelp*)
  {
    TRACE;

  }

} // namespace GeopsyGui
