/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-10-06
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ChronogramProperties.h"
#include "ChronogramLayer.h"

namespace GeopsyGui {

  /*!
    \class ChronogramProperties ChronogramProperties.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ChronogramProperties::ChronogramProperties(QWidget * parent)
    : PropertyWidget(parent)
  {
    TRACE;
    setupUi(this);
    _layer=0;
    // Create properties
    addProperty(MinimumGap, minimumGap);
  }

  void ChronogramProperties::setLayer(ChronogramLayer * layer)
  {
    TRACE;
    if(_layer) {
      exportButton->setEnabled(false);
    } else {
      _layer=layer;
    }
  }

  void ChronogramProperties::on_exportButton_clicked()
  {
    TRACE;
    if(_layer) {
      QString fileName=Message::getSaveFileName(tr("Export gap list"));
      if(!fileName.isEmpty()) {
        _layer->exportGaps(fileName);
      }
    }
  }

} // namespace GeopsyGui
