/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-08-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include <QGpGuiTools.h>
#include "ArrayDefinition.h"

namespace GeopsyGui {

ArrayDefinition::ArrayDefinition(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);
  // Set titles of columns in group list
  QTreeWidgetItem * headers=new QTreeWidgetItem;
  headers->setText(0, tr( "Group name"));
  headers->setText(1, tr( "Signal name"));
  headers->setText(2, tr( "Component"));
  headers->setText(3, tr( "Start time"));
  headers->setText(4, tr( "End time"));
  headers->setText(5, tr( "Rec x"));
  headers->setText(6, tr( "Rec y"));
  headers->setText(7, tr( "Rec y"));
  groupList->setHeaderItem(headers);
  // Fill in group list
  /* TODO arrange quick group browser
  QStringList geopsyGroups=GeopsyCoreEngine::instance()->currentDB() ->groupList();
  for(QStringList::Iterator it=geopsyGroups.begin();it!=geopsyGroups.end();++it) {
    QTreeWidgetItem * group=new QTreeWidgetItem(groupList, 0);
    group->setText(0, *it);
    SubSignalPool subPool;
    subPool.addGroup(GeopsyCoreEngine::instance()->currentDB(), *it);
    for(int i=0; i < subPool.count();++i) {
      Signal * sig=subPool.at(i);
      QTreeWidgetItem * station=new QTreeWidgetItem(group, 1);
      station->setText(0, QString::number(i) );
      station->setText(1, sig->name());
      station->setText(2, sig->componentUserName());
      station->setText(3, sig->timeReference().toString( "dd/MM/yyyy hh:mm:ss" ));
      station->setText(4, Time::secondsToTime(sig->t0(), 4) );
      station->setText(5, Time::secondsToTime(sig->endTime(), 4) );
      station->setText(6, QString::number(sig->receiver().x(), 'f', 3) );
      station->setText(7, QString::number(sig->receiver().y(), 'f', 3) );
      station->setFlags(Qt::ItemIsEnabled);
    }
  } */
}

ArrayDefinition::~ArrayDefinition()
{
  TRACE;}

void ArrayDefinition::on_capSettingsBrowse_clicked()
{
  TRACE;
  QString str=Message::getOpenFileName(tr("Choose CAP Settings file"), tr("settings file (*)"));
  if(str.length() > 0) capSettings->setText(str);
}


void ArrayDefinition::setCurrentGroup(QString groupName)
{
  TRACE;
  QList<QTreeWidgetItem *> items=groupList->findItems (groupName, Qt::MatchExactly, 0);
  groupList->setCurrentItem(items.first());
}

void ArrayDefinition::setStartTime(QString t)
{
  TRACE;
  QDate dt(t.mid(0, 4).toInt(), t.mid(4, 2).toInt(), t.mid(6, 2).toInt());
  QTime tm(t.mid(8, 2).toInt(), t.mid(10, 2).toInt(), t.mid(12, 2).toInt(), t.mid(15, 3).toInt());
  QDateTime dttm(dt, tm);
  startTime->setDateTime(dttm);
}

QString ArrayDefinition::getStartTime()
{
  TRACE;
  QString str=startTime->dateTime().toString("yyyyMMddhhmmss.zzz");
  return str;
}

void ArrayDefinition::setEndTime(QString t)
{
  TRACE;
  QDate dt(t.mid(0, 4).toInt(), t.mid(4, 2).toInt(), t.mid(6, 2).toInt());
  QTime tm(t.mid(8, 2).toInt(), t.mid(10, 2).toInt(), t.mid(12, 2).toInt(), t.mid(15, 3).toInt());
  QDateTime dttm(dt, tm);
  endTime->setDateTime(dttm);
}

QString ArrayDefinition::getEndTime()
{
  TRACE;
  QString str=endTime->dateTime().toString("yyyyMMddhhmmss.zzz");
  return str;
}

void ArrayDefinition::on_groupList_currentIndexChanged (QTreeWidgetItem * current, QTreeWidgetItem * )
{
  TRACE;
  if(current->type()==0)    // only a whole group is selected
    selectedGroup->setText(current->text(0) );
  else {
    QString groupName=current->parent() ->text(0);
    selectedGroup->setText(groupName);
    SubSignalPool subPool;
    /*
      TODO 
      subPool.addGroup(GeopsyCoreEngine::instance()->currentDB(), groupName);
    */
    /*Signal * sig=subPool.at(current->text(0).toInt());
    ms=sig->startTime();
    if(ms < 0)
      startTime->setDateTime(sig->timeReference().addSecs(( int) ms - 1) );
    else
      startTime->setDateTime(sig->timeReference().addSecs(( int) ms) );
    t=startTime->time();
    t.addMSecs(( int) floor(1000 * (ms - floor(ms) ) + 0.5) );
    startTime->setTime(t);

    ms=sig->endTime();
    if(ms < 0)
      endTime->setDateTime(sig->timeReference().addSecs(( int) ms - 1) );
    else
      endTime->setDateTime(sig->timeReference().addSecs(( int) ms) );
    t=endTime->time();
    t.addMSecs(( int) floor(1000 * (ms - floor(ms) ) + 0.5) );
    endTime->setTime(t);*/
  }
}

void ArrayDefinition::on_wdBrowse_clicked()
{
  TRACE;
  QString s=Message::getExistingDirectory(tr( "Cap working directory" ), wd->text());
  if(s.length() > 0) wd->setText(s);
}

} // namespace GeopsyGui
