/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-09-10
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SubSignalPoolProcess.h"
#include "SubSignalPool.h"

namespace GeopsyCore {

/*!
  \class SubSignalPoolProcess SubSignalPoolProcess.h
  \brief Convenient class to create a CacheProcess from a SubSignalPool

  CacheProcess is used select the best item to deallocate. For SubSignalPool functions,
  it is recommended to use this object only when several signal used at the same time
  to prevent stupid deallocations.
*/

/*!
  Description of constructor still missing
*/
SubSignalPoolProcess::SubSignalPoolProcess(const SubSignalPool& subPool)
    : CacheProcess()
{
  for(SubSignalPool::const_iterator it=subPool.begin(); it!=subPool.end(); it++) {
    add(*it);
  }
}

} // namespace GeopsyCore
