/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-01-30
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "StackCount.h"
#include "MetaDataFactory.h"

namespace GeopsyCore {

  /*!
    \class StackCount StackCount.h
    \brief Number of stack, metadata for Signal

    Number of stack is an optional integer available in SEG2 headers
  */

  REGISTER_METADATA(StackCount)

  QStringList StackCount::subNames() const
  {
    QStringList names;
    names << xmlStackCountTag;
    return names;
  }

  QString StackCount::name(int, const QString&) const
  {
    return xmlStackCountTag;
  }

  QString StackCount::baseName(int) const
  {
    return xmlStackCountTag;
  }

  QString StackCount::title(int, const QString&) const
  {
    return tr("Stack count");
  }

} // namespace GeopsyCore
