/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-11-06
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SEISMICEVENTTABLE_H
#define SEISMICEVENTTABLE_H

#include <QGpCoreTools.h>

#include "SeismicEvent.h"
#include "GeoSignal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT SeismicEventTable : public QObject, public XMLClass, private SortedVector<DateTime, SeismicEvent>
  {
    Q_OBJECT
  public:
    SeismicEventTable();
    ~SeismicEventTable();

    virtual const QString& xml_tagName() const {return xmlSeismicEventTableTag;}
    static const QString xmlSeismicEventTableTag;

    int count() const {return SortedVector<DateTime, SeismicEvent>::count();}
    SeismicEvent * at(int index) {return SortedVector<DateTime, SeismicEvent>::at(index);}

    bool contains(const SeismicEvent& e) const;
    const SeismicEvent * add(const SeismicEvent& e);
    void remove(const SeismicEvent& e);
    void remove(const ::VectorList<const SeismicEvent *>& events);
    void clear();
    void sort() {SortedVector<DateTime, SeismicEvent>::sort();}

    ::QList<const SeismicEvent *> events(const Signal * sig,
                                         double minimumSlowness=0.0, double maximumSlowness=0.0) const;
    ::QList<const SeismicEvent *> events(const SparseTimeRange& r) const;
    ::QList<const SeismicEvent *> events(const TimeRange& r) const;
    ::QList<const SeismicEvent *> events(const TimeRange& r, const Point& receiver,
                                         double minimumSlowness, double maximumSlowness) const;
    ::QList<const SeismicEvent *> eventsAt(const DateTime& t) const;

    bool isModified() const {return _modified;}
    void setModified(bool m) const {_modified=m;}

    // XML serialization
    virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
    virtual bool xml_polish(XML_POLISH_ARGS);
  signals:
    void eventAdded(SeismicEvent * e);
    void eventRemoved(SeismicEvent * e);
  private:
    mutable bool _modified;
  };

} // namespace GeopsyCore

#endif // SEISMICEVENTTABLE_H

