/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-01-30
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "OriginalFileName.h"
#include "MetaDataFactory.h"

namespace GeopsyCore {

  /*!
    \class OriginalFileName OriginalFileName.h
    \brief Original file name, meta data for Signal

    Original file name filled up in a different according to file format. It
    generally corresponds to the original file generated by the recording device
    itself.
  */

  REGISTER_METADATA(OriginalFileName)

  QStringList OriginalFileName::subNames() const
  {
    QStringList names;
    names << xmlOriginalFileNameTag;
    return names;
  }

  QString OriginalFileName::name(int, const QString&) const
  {
    return xmlOriginalFileNameTag;
  }

  QString OriginalFileName::baseName(int) const
  {
    return xmlOriginalFileNameTag;
  }

  QString OriginalFileName::title(int, const QString&) const
  {
    return tr("Original file name");
  }

} // namespace GeopsyCore
