/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-11-10
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GeopsyPreferences_H
#define GeopsyPreferences_H

#include "MetaDataFieldList.h"
#include "SignalFileFormat.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT GeopsyPreferences
{
  TRANSLATIONS("GeopsyPreferences")
public:
  GeopsyPreferences();
  ~GeopsyPreferences();

  // Loading preferences
  bool askForFormat() const {return _askForFormat;}
  SignalFileFormat fileFormat() const {return _fileFormat;}
  bool viewIfFewFiles() const {return _viewIfFewFiles;}
  int maxNofFiles() const {return _maxNofFiles;}
  bool showTable() const {return _showTable;}
  bool showGraphic() const {return _showGraphic;}
  bool oneWindowPerFile() const {return _oneWindowPerFile;}
  // Signal name
  bool stationNameFile() const {return _stationName==StationNameFile;}
  bool stationNameRxxx() const {return _stationName==StationNameRxxx;}
  // Event name
  bool eventNameFile() const {return _eventName==EventNameFile;}
  bool eventNameEmpty() const {return _eventName==EventNameEmpty;}
  // Viewers tab
  MetaDataFieldList& tableFields() {return _tableFields;}
  bool restoreGraphicMakeUp() const {return _graphicMakeUp;}
  QString graphicMakeUpFile() const {return _graphicMakeUpFile;}
  bool restoreMapMakeUp() const {return _mapMakeUp;}
  QString mapMakeUpFile() const {return _mapMakeUpFile;}
  bool restoreChronogramMakeUp() const {return _chronogramMakeUp;}
  QString chronogramMakeUpFile() const {return _chronogramMakeUpFile;}
  // Cache preferences
  uint cacheSize() {return _cacheSize;}
  QString cacheSwapDir() {return _cacheSwapDir;}

  void load();
  void save();
  void saveNoAuto();
  void restoreFileDefaults();
  void restorePoolDefaults();
protected:
  // Flags
  uint _askForFormat:1;
  uint _showTable:1;
  uint _showGraphic:1;
  uint _oneWindowPerFile:1;
  uint _viewIfFewFiles:1;
  uint _stationName:1;
  uint _eventName:1;
  uint _graphicMakeUp:1;
  uint _mapMakeUp:1;
  uint _chronogramMakeUp:1;
  uint _unused:19;

  enum StationName {StationNameFile=0x0, StationNameRxxx=0x1};
  enum EventName {EventNameFile=0x0, EventNameEmpty=0x1};

  // Loading prefs values
  SignalFileFormat _fileFormat;
  int _maxNofFiles;
  // Viewers prefs
  MetaDataFieldList _tableFields;
  QString _graphicMakeUpFile;
  QString _mapMakeUpFile;
  QString _chronogramMakeUpFile;
  // Cache preferences
  QString _cacheSwapDir;
  uint _cacheSize;
};

} // namespace GeopsyCore

#endif // GEOPSYPREFERENCES_H
