/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-05-03
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FOURIERPLAN_H
#define FOURIERPLAN_H

#include <QGpCoreMath.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT FourierPlan
  {
  public:
    FourierPlan(int n, double samplingPeriod, double frequency);

    int count() const {return _n;}
    double frequency() const {return _frequency;}
    inline Complex dtft(const double * samples) const;
    bool test(double samplingPeriod);
  private:
    int _n;
    double _frequency;
    TwiddleFactors _base;
  };

  inline Complex FourierPlan::dtft(const double * samples) const
  {
    Complex c;
    for(int k=0; k<_n; k++) {
      c+=_base.value(k)*samples[k];
    }
    return c;
  }

} // namespace GeopsyCore

#endif // FOURIERPLAN_H

