/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-01-25
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef UNIFORMPROFILE_H
#define UNIFORMPROFILE_H

#include "GradientProfile.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

  class DINVERDCCORE_EXPORT UniformProfile : public GradientProfile
  {
  public:
    UniformProfile() : GradientProfile(1) {}
    UniformProfile(const UniformProfile& o) : GradientProfile(o) {}

    virtual GradientProfile * clone() const {return new UniformProfile(*this);}

    virtual void setSubLayerCount(int);

    virtual bool setBottomValue(double) {return false;}
    virtual double bottomValue() const {return _vt;}

    virtual void setDepths(int topIndex, Profile& p) {p.setDepth(topIndex, _zb);}
    virtual void setValues(int topIndex, Profile& p) {p.setValue(topIndex, _vt);}

    virtual void setTopValue(double value, double) {GradientProfile::setTopValue(value);}
    virtual void setMinimumTopValue(double value, double) {GradientProfile::setTopValue(value);}
    virtual void setMaximumTopValue(double value, double) {GradientProfile::setTopValue(value);}
    virtual void setMinimumGradient(double, double) {}
    virtual void setMaximumGradient(double, double) {}
  };

} // namespace DinverDCCore

#endif // UNIFORMPROFILE_H

