/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-07-10
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef BOTTOMVALUECONDITION_H
#define BOTTOMVALUECONDITION_H

#include <DinverCore.h>

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

  class ParamLayer;

  class DINVERDCCORE_EXPORT BottomValueCondition : public AbstractCondition
  {
  public:
    BottomValueCondition();
    BottomValueCondition(ParamLayer * layer);

    bool isValid() const;

    virtual const QString& xml_tagName() const {return xmlBottomValueConditionTag;}
    static const QString xmlBottomValueConditionTag;

    virtual void getLimits(int paramIndex, double& min, double& max) const;
    virtual bool adjustRanges();
    virtual void humanInfo() const;
  protected:
    virtual uint internalChecksum() const {return 0;}
    virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
    virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  private:
    double thickness() const;
    double minimumBottomValue() const;
    double maximumBottomValue() const;
    inline void getLimitsTopValue(double& min, double& max) const;
    inline void getLimitsGradient(double& min, double& max) const;
    inline void getLimitsDepth(double& min, double& max) const;
    inline void getLimitsPreviousDepth(double& min, double& max) const;
    inline void getLimitsNextTopValue(double& min, double& max) const;
    bool setMinimumThickness();
    void setMaximumThickness();

    ParamLayer * _layer;
    QString _layerName;

    bool _isDepth;
    ParamLayer * _nextLayer;
    Type _nextLayerCondition;
  };

} // namespace DinverDCCore

#endif // BOTTOMVALUECONDITION_H

