/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-12-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REPORTREADER_H
#define REPORTREADER_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT ReportReader : public SharedObject
{
  TRANSLATIONS("ReportReader");
public:
  ReportReader() {}
  ReportReader(QString fileName);
  ~ReportReader() {}

  void setFileName(QString fileName) {_f.setFileName(fileName);}
  QString fileName() {return _f.fileName();}

  static bool isReportFormat(QString fileName);
  bool open();
  void close() {_f.close();}
  void synchronize();
  int nModels() {return _offsets.count();}

  double misfit(int index);
  void modelBlock(int index) {_f.seek(_offsets.at(index));}
  int userBlockVersion(const char * tag);
  inline  int userBlockVersion(int index, const char * tag);
  QDataStream& stream() {return _s;}
  int version() const {return _version;}

  qint64 lastBlockOffset();
private:
  QFile _f;
  QDataStream _s;

  QList<qint64> _offsets;
  int _version;
};


inline int ReportReader::userBlockVersion(int index, const char * tag)
{
  TRACE;
  _f.seek(_offsets.at(index)+8);
  return userBlockVersion(tag);
}

} // namespace DinverCore

#endif // REPORTREADER_H
