/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-06-13
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef BATCHRUN_H
#define BATCHRUN_H

#include <QGpCoreTools.h>

#include "TemporaryDirectory.h"
#include "AbstractForward.h"
#include "ReportWriter.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DinverInterface;

class DINVERCORE_EXPORT BatchRun : public QObject
{
  Q_OBJECT
public:
  BatchRun(QObject * parent=nullptr);
  ~BatchRun();

  bool setParameters(const QString& paramFile);
  bool setTargets(const QString& targetFile);
  bool neighborhoodOptimization(AbstractForward * forward, int ns0, int ns, int nb, int nr,
                                int expectedBestModelCount, double maximumSavedMisfit,
                                QString fileName, ReportWriter::Action reportAction);
  bool neighborhoodOptimization(int ns0, int ns, int nb, int nr,
                                int expectedBestModelCount, double maximumSavedMisfit,
                                QString fileName, ReportWriter::Action reportAction);
  bool importanceSampling(int ns, QString baseFileName,
                          QString fileName, ReportWriter::Action reportAction,
                          double degreesOfFreedom);
  bool artificialBeeColony(int ns0, int giveUp);
private:
  AbstractForward * createForward();
  // Mainly to maintain a pid file and signal termination
  TemporaryDirectory _tempDir;
};

} // namespace DinverCore

#endif // BATCHRUN_H
