/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-11-12
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SIMULATEDARRAYSTATIONS_H
#define SIMULATEDARRAYSTATIONS_H

#include "ArrayStations.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT SimulatedArrayStations : public ArrayStations
  {
  public:
    SimulatedArrayStations(const QList<NamedPoint>& array);
    ~SimulatedArrayStations();

    double samplingFrequnecy() const;
    Mode mode() const;
    int count() const;
    QString name(int index) const;
    Point2D position(int index) const;
    StationSignals * stationSignals(int) const;
  private:
    VectorList<NamedPoint> _stations;
  };

} // namespace ArrayCore

#endif // SIMULATEDARRAYSTATIONS_H

