/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-10-12
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SENSORORIENTATIONCAPON_H
#define SENSORORIENTATIONCAPON_H

#include "HRFKDirectRadial.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class CrossSpectrumSplit;

  class ARRAYCORE_EXPORT SensorOrientationCapon : public ConvFKVertical
  {
  public:
    SensorOrientationCapon(FKCache * cache);
    ~SensorOrientationCapon();

    FunctionSearch * createSearch(const FKParameters& param);

    void addCrossSpectrum();
    bool invertCrossSpectrum();

    double value(const Vector<int>& index) const;
    double value(Vector<double>& kell) const;
  private:
#if 0

    void scan2D(const Vector<double>& k, double range, int axis1, int axis2, const QString& fileName);
    class Function : public ConvFKVertical
    {
    public:
      Function(FKCache * cache);
      ~Function();

      void initialize();
      void setPowerEngine(FKPower * p) {ConvFKVertical::setPowerEngine(p);}

      double value(Vector<double>& x) const;
      void gradient(const Vector<double>& x, Vector<double>& grad) const;
    private:
      mutable Complex _ell;
      mutable ComplexMatrix _psiE, _psiN, _dpsiE, _dpsiN;
      mutable ComplexMatrix _finv;
      ComplexMatrix _fZZ, _fEE, _fEN, _fNE, _fNN, _fEZ, _fZE;
    };
    OptimizationBFGS * _optimization;
    PrivateVector<double> * _max;
#endif
    ComplexMatrix _fZZ;
  };

} // namespace ArrayCore

#endif // SENSORORIENTATIONCAPON_H

