/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-13
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SPACRESULTS_H
#define SPACRESULTS_H

#include "AbstractArrayResults.h"
#include "SPACParameters.h"
#include "MSPACStatistics.h"
#include "ESACStatistics.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class SPACPeaks;

  class ARRAYCORE_EXPORT SPACResults : public AbstractArrayResults
  {
  public:
    SPACResults();
    ~SPACResults();

    struct ValueInfo
    {
      DateTime time;
      int frequencyIndex;
      double frequency;
      double distance;
      int ringIndex;
    };

    const SPACParameters * parameters() const {return static_cast<const SPACParameters *>(_parameters);}

    void setArray(const ArraySelection * array);

    void setParameters(const SPACParameters& param);
    void clear();

    void addValue(Mode::Polarization polarization, const ValueInfo& info, double value);
    void addRejected(int frequency, int * rejected);

    void commitStatistics();
    bool save(QString fileName, const QString& log);
    void reportRejects();
  private:
    ModalCurve esacDispersionCurve(int iComp);

    Mutex _addLock;
    int _nFrequencies, _nRings, _nComponents;
    AutocorrCurves * _mspacTarget;
    MSPACStatistics * _mspacStats;
    ESACStatistics * _esacStats;
    int * _rejected[3];
    SPACPeaks * _peaks;
  };

} // namespace ArrayCore

#endif // SPACRESULTS_H

