/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-04
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPACCROSSSPECTRUM_H
#define SPACCROSSSPECTRUM_H

#include "ArrayCrossSpectrum.h"
#include "StationPairs.h"
#include "SPACParameters.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT SPACCrossSpectrum : public ArrayCrossSpectrum
  {
  public:
    SPACCrossSpectrum(const ArraySelection * array,
                      const SPACParameters * param);
    ~SPACCrossSpectrum();

    const SPACParameters * parameters() const {return static_cast<const SPACParameters *>(_parameters);}

    int stationPairCount() const {return _stationPairs.count();}
    const StationPair& stationPair(int index) const {return _stationPairs.at(index);}
    const VectorList<StationPair>& stationPairs() const {return _stationPairs;}

    int ringCount() const {return _rings.count();}
    const RingPairs& ring(int index) {return _rings.at(index);}

    bool calculate(const VectorList<int>& blocks);

    inline Complex verticalAutocorr(int station1, int station2) const;
    Complex radialAutocorr(int station1, int station2, const Angle& azimuth) const;
    Complex transverseAutocorr(int station1, int station2, const Angle& azimuth) const;
  private:
    void setStationPairs(const ArraySelection * array);
    void setRings();
    void normalize(ComplexMatrix& covmat);
    void resize();

    StationPairs _stationPairs;
    VectorList<RingPairs> _rings;
    ComplexMatrix * _horizontalMatrix;
  };

  inline Complex SPACCrossSpectrum::verticalAutocorr(int station1, int station2) const
  {
    return ArrayCrossSpectrum::matrix()->at(station1, station2);
  }

} // namespace ArrayCore

#endif // SPACCROSSSPECTRUM_H
