/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-09-30
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ORAWORKER_H
#define ORAWORKER_H

#include "ArrayWorker.h"
#include "ArrayCoreDLLExport.h"
#include "ORATaskManager.h"
#include "ORACrossSpectrum.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ORAWorker : public ArrayWorker
  {
  public:
    ORAWorker(const ArraySelection * array,
              const ArrayParameters * param);
    ~ORAWorker();

    void setTaskManager(ORATaskManager * tm) {ArrayWorker::setTaskManager(tm);}
  protected:
    inline const ORATaskManager * taskManager() const;

    virtual void process(const VectorList<int>& blocks);
  private:
    ORACrossSpectrum * crossSpectrum() {return static_cast<ORACrossSpectrum *>(_crossSpectrum);}
  };

  inline const ORATaskManager * ORAWorker::taskManager() const
  {
    return static_cast<const ORATaskManager *>(ArrayWorker::taskManager());
  }

} // namespace ArrayCore

#endif // ORAWORKER_H

