/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-09-30
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ORACROSSSPECTRUM_H
#define ORACROSSSPECTRUM_H

#include "ArrayCrossSpectrum.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ORACrossSpectrum : public ArrayCrossSpectrum
  {
  public:
    ORACrossSpectrum(const ArraySelection * array,
                     const ArrayParameters * param);
    ~ORACrossSpectrum();

    bool calculate(const VectorList<int>& blocks);
    double value(int i1, int i2, double theta1, double theta2) const;
    double defaultAngle(int i1, int i2);
  private:
    const ArraySelection * _array;
    ComplexMatrix * _sigs;
    ComplexMatrix * _pairMatrices;
  };

} // namespace ArrayCore

#endif // ORACROSSSPECTRUM_H

