/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-10-14
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef INCOHERENTNOISE_H
#define INCOHERENTNOISE_H

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT IncoherentNoise
  {
  public:
    IncoherentNoise();

    void add(double power, double Rh, double Rz);

    void showStatus() const;
    double R() const;
    double sigma() const;
  private:
    int _count;
    double _power;
    double _etaH, _etaZ;
    double _sigma[2];
  };

} // namespace ArrayCore

#endif // INCOHERENTNOISE_H

