/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-03
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKTaskManager.h"
#include "FKWorker.h"
#include "FKResults.h"

namespace ArrayCore {

  /*!
    \class FKTaskManager FKTaskManager.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  FKTaskManager::FKTaskManager(const ArraySelection * array)
    : ArrayTaskManager(array)
  {
    TRACE;
    _gridCache=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  FKTaskManager::~FKTaskManager()
  {
    TRACE;
    delete _gridCache;
  }

  bool FKTaskManager::setParameters(const ArrayParameters * param)
  {
    TRACE;
    const FKParameters * fkParam=dynamic_cast<const FKParameters *>(param);
    if(!fkParam) {
      qDebug() << "Parameters are not FKParameters in FKTaskManager::setParameters.";
      return false;
    }
    if(!ArrayTaskManager::setParameters(param)) {
      return false;
    }
    _gridCache=new FKCache(&_array);
    return true;
  }

  LoopWorker * FKTaskManager::newWorker()
  {
    TRACE;
    FKWorker * w=new FKWorker(&_array, parameters());
    w->setTaskManager(this);
    if(!w->setGrid(_gridCache)) {
      delete w;
      w=nullptr;
    }
    return w;
  }

} // namespace ArrayCore

